function exportEngine(eng, spreadsheet_name)

spreadsheet_name = spreadsheet_name + ".xlsx";

% Main data
mainData = table('Size', [0 3], ...
    'VariableTypes', ["string", "double", "string"], ...
    'VariableNames', ["Main Parameters", "value", "unit"]);

mainData(end+1, :) = {"Full Name", eng.fullName, ""};
mainData(end+1, :) = {"Displacement", eng.displacement * 1e3, "l"};
mainData(end+1, :) = {"Rated power", eng.ratedPwr, "kW"};
mainData(end+1, :) = {"Moment of inertia", eng.inertia, "kg*m^2"};
mainData(end+1, :) = {"Idle speed", eng.idleSpd, "rpm"};
mainData(end+1, :) = {"Max speed", eng.maxSpd, "rpm"};
mainData(end+1, :) = {"Mass", eng.mass, "kg"};
mainData(end+1, :) = {"Fuel lower heating value", eng.LHV, "J/kg"};
mainData(end+1, :) = {"Fuel density", eng.density, "kg/l"};
mainData(end+1, :) = {"CO2ttw factor", eng.CO2ttwFactor, "kgCO2/kgFuel"};

% limit and motoring torque characteristics
limDataHeader = table("rpm", "Nm", "Nm", 'VariableNames', ...
    ["speed", "max torque", "motoring torque"]);
limData = table(eng.maxTrq.GridVectors{1}(:) .* 30/pi, eng.maxTrq.Values(:), ...
    eng.motTrq.Values(:));

% map data
mapDataHeader = cell2table(eng.mapData.Properties.VariableUnits);
mapDataHeader.Properties.VariableNames = string(eng.mapData.Properties.VariableNames);
mapData = eng.mapData;

% Write to spreadsheet
writetable(mainData, spreadsheet_name, Sheet = "main")
writetable(limDataHeader, spreadsheet_name, Sheet = "lim")
writetable(limData, spreadsheet_name, Sheet = "lim", ...
    WriteVariableNames = false, Range = "A3")
writetable(mapDataHeader, spreadsheet_name, Sheet = "map")
writetable(mapData, spreadsheet_name, Sheet = "map", ...
    WriteVariableNames = false, Range = "A3")

end